/* 
Function supplied with Fwatch v1.13
Merges strings together and executes them as an Fwatch command
Usage:
	[<string or array with strings>, ...] call preProcessFile "..\fwatch\data\ExecCommand.sqf"
	
Input 
	is an array filled with strings or sub-arrays with strings.
	Any of the strings musn't be longer than 123 characters
	
Output 
	is the output data of the target command	
	
Example:
	_return = ["mem ","getplayeraim"] call preProcessFile "..\fwatch\data\ExecCommand.sqf"


Changelog:
1.14
- optimized code (less calls to fwatch)
- char limit from to 116 to 123
- does not return error array if the function failed
- works around campaign char limitation
*/


private ["_i", "_error", "_item", "_strings", "_limit", "_lengths", "_j", "_chars", "_ok", "_return", "_info"];
_i = 0;
_limit = 98;
_strings = [];
_lengths = [];
_error = false;

// Get character limit for this mission
if (Format ["%1",FLIB_EXEC_BASEPATHLEN] == "scalar bool array string 0xfcffffef") then 
{
	_info = call loadFile "..\fwatch\data\path.sqf";
	FLIB_EXEC_BASEPATHLEN = if (_info select 0 == 7) then {_info select 1} else {-1}
	
};
if (Format ["%1",FLIB_EXEC_BASEPATHLEN] != "scalar bool array string 0xfcffffef") then 
{
	// 155 or 152 wtf?
	if (FLIB_EXEC_BASEPATHLEN > 0) then {_limit=152-FLIB_EXEC_BASEPATHLEN-24}
};







// Get rid of sub-arrays and measure strings
while "_i < count _this  &&  !_error" do
{
	_item = _this select _i;
	if (_item in [_item]) then 
	{
		_strings = _strings + [_item];
		_j = call loadFile Format [":s %1", _item];
		if (_j>123) then {_error=true};
		_lengths = _lengths + [_j];
	} 
	else
	{
		"_j=call loadFile Format ["":s %1"", _x]; _lengths=_lengths+[_j]; _strings=_strings+[_x]; if (_j>123) then {_error=true}" forEach _item
	};
	_i = _i + 1;
};







// Merge/split strings if possible
_i = 0;
while "_i < (count _strings)  &&  !_error" do
{
	 // If string is more than what we can write
	 if ((_lengths select _i) > _limit) then
	 {
		// Extend array
		_j = count _strings;
		while "_j > _i" do
		{
			_strings set [_j, _strings select (_j-1)];
			_lengths set [_j, _lengths select (_j-1)];
			_j = _j - 1
		};
		
		_lengths set [_i+1, (_lengths select _i)-_limit];
		_lengths set [_i, _limit];
		
		// Split string into single chars, merge it into desired size
		// Insert two resulting strings into array
		_j = 0;
		_item = "";
		_chars = call loadFile Format [":s[ %1", _strings select _i];
		"_item=_item+_x; _j=_j+1; if (_j==_limit) then {_strings set [_i,_item]; _item=""""}" forEach _chars;	
		_strings set [_i+1, _item];
	 };
	
	
	 // If two adjacent strings in the array can be merged
	 if (_i < (count _strings)-1) then
	 {
		if ((_lengths select _i) + (_lengths select (_i+1)) <= _limit) then
		{
			_strings set [_i, (_strings select _i) + (_strings select (_i+1))];
			_strings set [_i+1, objnull];
			_strings = _strings - [objnull];
			
			_lengths set [_i, (_lengths select _i) + (_lengths select (_i+1))];
			_lengths set [_i+1, objnull];
			_lengths = _lengths - [objnull];
			_i = _i - 1;
		};
	};
	
	_i = _i + 1
};








// Set random name for a temporary file
_i = 0;
_ok = [];
_item = "";
_fwatch_error = [true,0,0,""];
_chars = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","1","2","3","4","5","6","7","8","9","0"];
while "_i < 5  &&  !_error" do
{
	_j = random (count _chars);
	_j = _j - (_j mod 1);
	_item = _item + (_chars select _j);
	_i = _i + 1;
	
	if (_i==5) then
	{
		_ok = call loadFile Format [":in ..\fwatch\tmp\%1 a-", _item];
		if ((_ok select 1)==207) then {_i=0; _item=""}
	}
};





// For each item in the array
_i = 0;
while "(_ok select 0)  &&  _i<count _strings  &&  !_error" do
{
	call loadFile Format [":IW ..\fwatch\tmp\%1 %2", _item, _strings select _i];
	_i = _i + 1
};



// Execute if there were no errors
_return = "";
if (_fwatch_error select 0  &&  !_error) then 
{
	_return = loadFile Format [":File execute ..\fwatch\tmp\%1", _item]
};

_return
